latexbegin :-
    write('\\documentclass[12pt,german]{article}'),nl,
    write('\\usepackage{babel}'),nl,
    write('\\usepackage[]{german,a4}'),nl,
    write('\\usepackage[T1]{fontenc}'),nl,
    write('\\usepackage[latin1]{inputenc}'),nl,
    write('\\usepackage[]{pslatex} % nicht bitmap, sondern postscript (type 1, vector)'),nl,
    write('\\setlength{\\topmargin}{-6.1mm}'),nl,
    write('\\setlength{\\oddsidemargin}{-3.4mm}'),nl,
    write('\\setlength{\\evensidemargin}{-3.4mm}'),nl,
    write('\\setlength{\\textwidth}{150mm}   % -> Rand links 5mm breiter als rechts '),nl,
    write('\\setlength{\\textheight}{236mm}'),nl,
    write('\\setlength{\\columnsep}{8mm}'),nl,
    write('\\setlength{\\columnseprule}{0.4pt}'),nl,
    write('\\parindent0mm'),nl,
    write('\\parskip2ex plus1ex minus1ex'),nl,
    write('\\begin{document}'),nl.

% auf Datei gesamt.tex
endresultlatex :- 
	leere(bp),
	check_boards, % Test, ob alle Boards gespielt  TEST1
	lade('result.pl'),
	% listing(res),
	resultat1latex,!.
endresultlatex.
resultat1latex :- loesche_datei('gesamt.tex'),fail.
resultat1latex :- 
    auswertung(Sol),
    tell('gesamt.tex'),current_output(Out),
    latexbegin,
    show_gesamt_latex('',Sol),!,
    alles_personen1_latex,
    bresult1_latex,
    strafen_latex,
    write('\\end{document}'),nl,
    close(Out),
    told.

show_gesamt_latex(_T1,R) :-
	turnier_info(Typ),
        write('\\section*{Gesamtresultat}\\begin{center}{\\large\\begin{tabular}{llll}'),nl,
        write('Platz & Wer & Punkte & Proz\\\\\\hline'),nl,
	clause(personen(P),true),
	el_gen([Platz,N,Punkte,_Max,Proz],R),
	el_gen([N,Name],P),not_dummy(N,Name),
	runde_zahl(Punkte,Punkte1,1),
	runde_zahl(Proz,Proz1,2),
	generiere_zeile([N,'  ',Name],NrName),
	write(Platz),
	once((Typ=[mitch,_], Res=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,NS,OW,_Points],
		res(Res),
		((N=NS,write(' (NS) ');N=OW,write(' (OW) ')))
		;
		Typ \= [mitch,_])),
	tabb,write(NrName),tabb,write(Punkte1),tabb,write(Proz1),write('\\\\'),nl,
	fail.
show_gesamt_latex(_,_) :-
        write('\\end{tabular}}\\end{center}'),nl.

tabb :- write(' & ').


% Strafen
strafen_latex :- once(clause(strafe(_,_),_)),
	write('\\section*{Strafen} '),nl,
	write('\\begin{tabular}{|l|l|}\\hline'),nl,
	write('Wer & Welche Strafe\\\\\\hline'),nl,
        strafe(Wer,Was),
        write(Wer),write(' & '),write(Was),write('\\\\\\hline'),nl,
        fail.
strafen_latex :- clause(strafe(_,_),_), write('\\end{tabular}'),nl,nl,!.
strafen_latex.

% ------------ Resultat nach Personen ----------------
alles_personen1_latex :-
	clause(personen(Paare),true),
	el_gen([Nummer,Paar],Paare),not_dummy(_,Paar), /* dummy */
%	write('\\hrule'),nl,
	write('\\section*{Spieler/Paar '),write(Nummer),write(': '),write(Paar),write('}'),nl,
	show_head_latex,
	boards(Boards),
	Res=[Board,_Runde,_Tisch,_Gefahr,_Teiler,NS,OW,_Points],
	Cond=((el_gen(Board,Boards),
		(NS=Nummer;OW=Nummer
		;
		((NS=[X,Y];OW=[X,Y]),(Nummer=X;Nummer=Y))),
		search_paar(Nummer,Boards,Board,Punkte,Proz))),
	show1_latex(Cond,Res,Nummer,Punkte,Proz),
	fail.
alles_personen1_latex.

show_head_latex :- 
	write('\\begin{tabular}{llllllll}'),nl,
        write('Bo & Ru & Ti & Gefahr & ~~~~~~~~~NS-OW & Score & \\\\\\hline'),nl.
show_head_latex :- write('\\end{tabular}'),nl,fail.

% Ohne Turnierpunkte
show1_latex(Cond,Res) :-
	Res=[Board,Runde,Tisch,_Gefahr,_Teiler,NS,OW,_Points],
	Cond,   res(Res),
	once((real_runde(Tisch,Runde,NS,OW,Boards),el_gen(Board,Boards))),
	show_res_latex(Res,no,'',''),
	fail.
show1_latex(_,_).
% mit Turnierpunkten
show1_latex(Cond,Res,Spieler,Punkte,Proz) :-
	Res=[Board,Runde,Tisch,_Gefahr,_Teiler,NS,OW,_Points],
	Cond,   res(Res),
	once((real_runde(Tisch,Runde,NS,OW,Boards),el_gen(Board,Boards))),
	show_res_latex(Res,Spieler,Punkte,Proz),
	fail.
show1_latex(_,_,_,_,_).

show_res_latex([Board,Runde,Tisch,Gefahr,_Teiler,NS,OW,Punkte],Spieler,TPunkte,Prozente) :-
    write(Board),tabb,write(Runde),tabb,write(Tisch),tabb,write(Gefahr),tabb,
    prepare2(NS,NSS,Spieler),prepare2(OW,OWW,Spieler),
    combine([NSS,' / ',OWW],SpielerAlle),write(SpielerAlle),tabb,
    once(((Punkte=p(_);Punkte=p(_,_);Punkte=p(_,_,_,_);
	  Punkte=eins(_);Punkte=zwei(_);Punkte=drei(_);Punkte=vier(_)),
	  Punkte1=Punkte
	  ;
	  Punkte=n,Punkte1=n
	  ;
	  Punkte1 is Punkte)),
    write(Punkte1),tabb,
    once((TPunkte='' ;
	  TPunkte=..[p|_] ;
	  generiere_zeile([TPunkte,' Pkt'],Points),
	  write(Points))),tabb,
	once((Prozente='';generiere_zeile([Prozente,'\\%'],Procent),write(Procent))),
	write('\\\\'),nl,!.

prepare2([A,B],X,_Wer) :- !,
%       clause(personen(M),true),
%	once((A==Wer,ANS=' ' ; el_gen([A,AN],M),combine([' (',AN,') '],ANS))),
%	once((B==Wer,BNS=' ' ; el_gen([B,BN],M),combine([' (',BN,') '],BNS))),
	ANS=' ',BNS=' ',
	combine([A,ANS,' + ',B,BNS],X),!.
prepare2(A,X,Wer) :- clause(personen(M),true),
	once((A==Wer,ANS=' ' ; el_gen([A,AN],M),combine([' (',AN,') '],ANS))),
	combine([A,ANS],X),!.

% ----------------- Resultate pro Board ------------------
bresult1_latex :-
    boards(Boards),el_gen(Board,Boards),
    boardres(Board,R,Max),boardfreq(Board,Freq),
    Cond=((Res=[Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,_Points])),
    %	write('\\hrule'),nl,
    write('\\section*{Board '),write(Board),write('}'),nl,
    once(show_head_latex), show1_latex(Cond,Res), write('\\end{tabular}'),nl,nl,
    show_br_latex('Punkte ',R,Max),
    show_freq_latex('Frequenzen ',Freq),
    fail.
bresult1_latex. 

show_br_latex(Text1,R,Max) :-
    clause(personen(P),true),
    write('\\begin{minipage}{9cm}\\subsection*{'),write(Text1),write('}'),nl,
    write('\\begin{tabular}{lll}'),nl,
    write('Punkte & Proz & Spieler\\\\\\hline'),nl,
    (el_gen([N,Punkte],R),Pos=left
     ;
     el_gen([Paar,Punkte],R),(Paar=[N,_],Pos=left;Paar=[_,N],Pos=right)),
    el_gen([N,Name],P),not_dummy(N,Name),
    once((Punkte=..[p|_],prozente(Punkte,Pos,max,Proz),
	  % Ersetzen eventueller Minus/Plus-Resultate 
	  ersetze_minusplus(N,Proz,Proz2),runde_zahl(Proz2,Proz1,1),
	  tabb,write(Proz1);
	  prozente(Punkte,Pos,Max,Proz),write(Punkte),tabb,
	  runde_zahl(Proz,Proz1,1),write(Proz1))),
	write('\\%  '),tabb,
	write(N),write(' '),write(Name),write(' \\\\'),nl,fail.
show_br_latex(_,_,_) :- write('\\end{tabular}\\end{minipage}'),nl.


show_freq_latex(Titel,Freq) :-
    write('\\begin{minipage}{6cm}\\subsection*{ '),write(Titel),write('}'),nl,
    write('\\begin{tabular}{llll}'),nl,
    write('Punkte & Anzahl & NS & OW \\\\\\hline'),nl,
    show_freq1_latex(Freq),
    write('\\end{tabular}\\end{minipage}'),nl,nl.
show_freq1_latex([]) :- !.
show_freq1_latex([[Anzahl,Punkte,NS,OW]|T2]) :-
	write(Punkte),tabb,write(Anzahl),tabb,
	(number(NS),runde_zahl(NS,NS1,1);NS=NS1),write(NS1),write('\\%'),nl,tabb,
	(number(OW),runde_zahl(OW,OW1,1);OW=OW1),write(OW1),write('\\%'),nl,
	write('\\\\'),nl,  !,
	show_freq1_latex(T2).

