% BR - Hauptmodul 	JCl 2008

% --------------- TURNIERDATEN : Turnierform, Paare, Boardanzahl !!  ---------------
% TURNIERFORM
editturnierform :-
	new(FE, frame('Turnierform')),  % erzeugt einen Dialogframe
	send(FE,append, new(DE, dialog('Turnierform waehlen'))),
	send_list(DE, append, [label(help,
'Wenn Sie die Turnierform aendern, dann gehen
alle bisherigen Daten verloren.
Welche Turnierform wollen Sie ?'),
		button(paar, and(message(@prolog,set_form,paar),
				% message(@prolog,set_geom,turnierform,FE,position),
				message(DE, destroy))), % schliesst Dialogframe
		button(individual, and( message(@prolog,set_form,individual),
				%	message(@prolog,set_geom,turnierform,FE,position),
					message(DE, destroy))), % schliesst Dialogframe
		button(abbruch, and(message(@prolog,set_geom,turnierform,FE,position),
					message(DE, destroy)))
				]),
%      send(FE, open_centered(Point,true)). % oeffnet den Dialogframe zentriert auf dem Mittelpunkt des Ausgangsframes
      % ask_geom(turnierform,FE,position),
      send(FE, open). % offnet den Dialogframe


% SPIELER eingeben und RUNDEN waehlen
editspieler :- exists(form(_)),!,
    repeat,
    mess_window('Wenn Sie die Namen editieren,
gehen alle bisher eingegebenen Resultate verloren.
Moechten Sie nur die Namen aendern und nicht bereits eingegebene Resultate,
so aendern Sie die Namen bitte erst in der Resultatsdatei.',
		[ok],_Auswahl),
    leere(bp),
    emacs('namen.txt').
%	mess_window('Sind Sie fertig?? Vergessen Sie zum Schluss das Speichern nicht !!',[ok],_),
%	turnierdaten1,
%	!.
editspieler :- send(@display, inform, 'Bitte waehlen Sie zunaechst die Turnierform'),!.

% Var 2: Nur die Namen editiern.
editspieler2 :- exists(form(_)),exists(personen(_)),!,
    repeat,
    mess_window('Ändern Sie hier NUR die Namen, aber nicht die Spieleranzahl!',
		[ok],_Auswahl),
    leere(bp),
    emacs('namen.txt'), 
    mess_window('Wenn Sie fertig sind, klicken Sie bitte OK.',	['OK'],_Auswahl2),
%    send(@display, inform, 'Sind Sie fertig?'),
    initialize_personen2(_,_),
    !.
editspieler2 :- send(@display, inform, 'Bitte waehlen Sie zunaechst die Turnierform
und geben Sie die Spieler ein.'),!.

% editspieler2a :- initialize_personen2(_,_),!.

check_form :- exists(form(_)),!.
check_form :- send(@display, inform, 'Bitte waehlen Sie zunaechst die Turnierform'),!,fail.

turnierdaten1 :- check_form,
	mess_window('Wenn Sie die Boards/Runden editieren,
gehen alle bisher eingegebenen Resultate verloren.',
	[ok],_Auswahl),
	turnierdaten1a.
turnierdaten1.
turnierdaten1a :- reset_result_all,fail.
turnierdaten1a :- turnierdaten2.

turnierdaten2 :- initialize_personen(_N,N1),
	(form(paar),N2 is N1 // 2,Form = paar
	 ;
 	 form(individual),N2 is N1,Form = individual),
	turnier_form(Form,N2,How,Runden,B),look_how(How,HN),
	quelldir(Dir),
	combine([Dir,HN,N2,'-',Runden,'-',B],File),
	once((lade(File),message([File,' geladen !'])
		; message([File,' nicht existent']))),
	erzeuge_result_files,  % NEU result.pl wird sofort erzeugt
	kill(turnier_info(_)),assert(turnier_info([HN,File])),
	!.

% paar/individual +, gerundete Paar-Anzahl +, Typ -, Runden -, Boards -
turnier_form(Form,N2,How,Runden,B) :-
	candidate(Form,N2,Typen),write(Typen),nl,
	(Typen=[[How,Runden|Boards]]
	  ; 
	  Typen\=[_],collect_first(Typen,TypenHow),
	  	(TypenHow=[How]
	  	;
	  	TypenHow\=[_],
	  	menu_window('Bitte Turnierform waehlen !',TypenHow,How)),
	  collect_runden(How,Typen,RundenListe),
	  (RundenListe=[Runden]
	   ;
	   RundenListe\=[_],
	      menu_window('Bitte Runden waehlen !',RundenListe,Runden)),
	  member([How,Runden|Boards],Typen)),
	(Boards = [B] 	
	;   
	Boards \= [_],menu_window('Bitte Zahl der Boards pro Runde waehlen !',Boards,B)),
	set_runden(Runden),
	set_boardsprorunde(B),
	!.

collect_first([],[]) :- !.
collect_first([[H|_]|Rest],R) :- member([H|_],Rest),!,collect_first(Rest,R).
collect_first([[H|_]|Rest],[H|R]) :- collect_first(Rest,R).

collect_runden(_How,[],[]) :- !.
collect_runden(How,[[How,Runden|_]|Typen],[Runden|RundenListe]) :- !,
	collect_runden(How,Typen,RundenListe).
collect_runden(How,[_|Typen],RundenListe) :-
	collect_runden(How,Typen,RundenListe).

round_personen(N,N) :- form(individual),!.
round_personen(N,N) :- N is N // 2 * 2,!.
round_personen(N,N1) :- N1 is N + 1.

% Kandidaten stehen unter brcandi

% ------------- Ende der Turnierform ---------------------

% ------------- Eingabe der Personen ---------------------
% ueber die Datei namen.txt
% Dort zeilenweise die Namen der Paare / Spieler eingeben.
% Bei Sonderzeichen in ' .... ' einschliessen.
% jeweils Abschluss durch .

initialize_personen(N,N1) :- % falls ungerade Anzahl Paare, wird mit dummy aufgefuellt !!
	ask_get_personen, 	set_persons(N,N1),!.

% Variante 2: Jetzt werden nur die Personen editiert. Nur personen/1 wird neu gesetzt.
initialize_personen2(N,N1) :- % falls ungerade Anzahl Paare, wird mit dummy aufgefuellt !!
	ask_get_personen, 	set_persons2(N,N1),!.

% ------------------------------------------------------------
% Setzen der Turnier-relevanten Infos
% Setzt Personen und setzt alles zurück
set_persons(N,N1) :-
	clause(personen(_),_),once(personen(P)),length(P,N),
	round_personen(N,N1),
	(N==N1  ;  N\==N1,retract_once(personen/1,personen(Liste)),
			appendd(Liste,[[100,dummy]],Liste1),
			enum(Liste1,Liste2),assert(personen(Liste2)) ),
	kill(persons(_)),assert(persons(N1)),!,set_data.
set_persons(0,0).
% Ändert NUR die Personen
set_persons2(N,N1) :-
	clause(personen(_),_),once(personen(P)),length(P,N),
	round_personen(N,N1),
	(N==N1  ;  N\==N1,retract_once(personen/1,personen(Liste)),
			appendd(Liste,[[100,dummy]],Liste1),
			enum(Liste1,Liste2),assert(personen(Liste2)) ),
	kill(persons(_)),assert(persons(N1)),!.
set_persons2(0,0).

set_boardsprorunde(BpR) :-
	kill(boardsprorunde(_)),assert(boardsprorunde(BpR)),!,set_data.
set_runden(Runden) :-
	kill(rundenzahl(_)),assert(rundenzahl(Runden)),!,set_data.
% set_form(F) :- kill(form(_)), assert(form(F)),!,set_data.
set_form(F) :- kill(form(_)), klausel_insert(form(F)),!,set_data.
% ------------------------------------------------------------
	
ask_get_personen :- 
	kill(personen(L)), lies_namen(Liste), init_personen, %del_dummy,
	member(Name,Liste),max_paar(N),N1 is N+1,
	retract_once(personen/1,personen(L)),
	appendd(L,[[N1,Name]],L1),assert(personen(L1)),
	fail.
ask_get_personen :- leere(bp),zeige_personen,jn_window('Ist das korrekt ?',Answer),!,Answer==ja.
% ask_get_personen  :- editspieler.

setze_cut(abort,!) :- !.
setze_cut(close,!) :- !.
setze_cut(_,true).

% -- Eingabe der Namen ueber Datei namen.txt -----
lies_namen(Liste) :- seeing(See),
	see('namen.txt'),
	current_input(M),
	lies_namen1(M,Liste), % NEU
	close(M), see(See).

% ALT lies_namen1(Res) :- read(J),%write(J),nl,
%	(J=end_of_file,Res=[];	Res=[J|Rest],lies_namen1(Rest)),!.

% NEU
lies_namen1(Stream,[]) :- peek_char(Stream,M),M=end_of_file,!.
lies_namen1(Stream,Res) :- read_line_to_codes(Stream,J,[]),
    reduziere(J,J1),
    once((J1=[],Res=Rest ; atom_chars(J2,J1),Res=[J2|Rest])),
    lies_namen1(Stream,Rest),!.
lies_namen1(_Stream,[]).

/* noch unfertig
% liefert auf J2 entweder 
%      - nur den Namen oder 
%      - [Nr,Name] zurueck
% sucht in den Strings nach dem Doppelpunkt (Code 58)
teile_liste(A,[Nr,Name]) :-
    append(Nr1,[58|Name1],A),!,
write(ok),nl,
    number_chars(Nr,Nr1),
write(Nr),nl,
    atom_chars(Name,Name1).
teile_liste(A,Name) :- atom_chars(Name,A).
*/

% Sonderzeichen in den Zeilen raus, %-Zeilen ignorieren
reduziere(L1,L2) :-
    reduziere1(L1,L3),
    reduziere2(L3,L2).

% evtl Zeichen IM String herausfiltern
reduziere2(L,L) :- !.
% Sonderzeichen weg wieso ?
%reduziere2([X|S],S1) :- weg(X),!,reduziere2(S,S1).
% Apostrophe
%weg(39). weg(96). weg(63).
 
% Leerzeichen am Anfang ignorieren
reduziere1([32|S],S1) :- !,reduziere1(S,S1).
% am Zeilenende Newline, Punkt und Leerzeichen ignorieren
reduziere1(S,S1) :- reverse(S,S2),S2=[X|S3],(X=46;X=10;X=13;X=32),!,
	reverse(S3,S4),!,reduziere1(S4,S1).
% Proz am Anfang !!
reduziere1([37|_],[]) :- !.
reduziere1(S,S).

%init_personen :- clause(personen(_),true),!.
init_personen :- assert(personen([])).

%del_dummy :- clause(personen(Paare),true),del([_,dummy],Paare,Paare2),!,
%	retract_once(personen/1,personen(Paare)),assert(personen(Paare2)).
%del_dummy.

zeige_personen :- zeige_personen1.
zeige_personen1 :- clause(form(paar),true),
	clause(personen(M),true),el_gen([N,X],M),not_dummy(N,X),
	generiere_zeile([' Paar-Nr. ',N,' : ',X],Aus),
	info(prot,Aus,0),
	info(prot,nl,0),fail.
zeige_personen1 :- clause(form(individual),true),
	clause(personen(M),true),el_gen([N,X],M),
	generiere_zeile([' Spieler-Nr. ',N,' : ',X],Aus),
	info(prot,Aus,0),
	info(prot,nl,0),fail.
zeige_personen1.

max_paar(N) :- clause(personen(P),true),!,length(P,N).

% ---------- ENDE der Eingabe der Spieler -------------------

	
% ----------- EINGABE und MODIFIKATION von Resultaten -------
eingabe :- eingabe1,!.           eingabe.

eingabe1 :-
    % result.pl wird nur EINMAL (nach Rundenfrage) erzeugt,
    % danach beliebig editierbar
    % erzeuge_result_files,
	emacs('result.pl').
%	mess_window('Editieren Sie die Dateien result.pl
%und bestaetigen Sie DANACH mit WEITER',
%                        [weiter],_Answer),
resultladen :- kill(strafe(_,_)),consult('result.pl').
    % ,listing(res),listing(strafe).

% --- benoetigt boards/1, runden/1,
% erzeugt die Datei result.pl
% erzeuge_result_files :- schliesse_datei('result.pl'),fail.
erzeuge_result_files :- reset_datei('result.pl'),fail.
erzeuge_result_files :- 
 	telling(Tell),
	(tell('result.pl') ; nl,told,tell(Tell),fail),
	current_output(Stream),
	write(':- dynamic res/1.'),nl,nl,
	(true
	 ;
	 nl,write('% Strafen als strafe(paar,p(prozente)).'),nl,nl,
	 clause(strafe(_,_),_),listing(strafe/2),fail
	 ;
	 close(Stream),fail),
% listing(res),
% Result.pl erzeugen
    gen_resfile.
erzeuge_result_files :- !,write(fertig).
erzeuge_result_files.

% Fallunterscheidung, ob schon res-Klauseln exitieren oder nicht.
 gen_resfile :- %
    boards(Boards),runden(Runden),
    once((                 % Resultat exisitert schon
			    member(Board1,Boards),
			    el_gen(Runde1,Runden),  % Generieren einer Runde
			    real_runde(Tisch1,Runde1,NS1,OW1,BoardListe1),
			    member(Board1,BoardListe1), % Test, ob es ein echtes Spiel ist
			    Res1=[Board1,Runde1,Tisch1,Gefahr1,Teiler1,NS1,OW1,Result1],
			    exists(res(Res1)),res(Res1)
	  )),!,
    member(Board,Boards),
    nl,write('%  BOARD   '),write(Board),nl,
    write('% - Board,Runde,Tisch,Gefahr, Teiler,NS,OW,             Result ---'),nl,
    el_gen(Runde,Runden),  % Generieren einer Runde
    Res=[Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Result],
    res(Res),
    format_write(res(Res)),
    fail.

% NEIN
gen_resfile :- %
	boards(Boards),runden(Runden),
	member(Board,Boards),
	nl,write('%  BOARD   '),write(Board),nl,
	write('% - Board,Runde,Tisch,Gefahr, Teiler,NS,OW,             Result ---'),nl,
	el_gen(Runde,Runden),  % Generieren einer Runde
	real_runde(Tisch,Runde,NS,OW,BoardListe),
        member(Board,BoardListe), % Test, ob es ein echtes Spiel ist
	Res=[Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Result],
	    	(exists(res(Res)),once(res(Res))
		;
		 negativ(exists(res(Res))),ask_gefahr(Board,Gefahr),
		    	ask_teiler(Board,Teiler),Result=0),
	format_write(res(Res)),
	fail.
    


format_write(res([Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Result])) :-
	current_output(Stream),

/* geht nicht
	generiere_zeile([
	['res([',5],
	[Board,3],[',',1],
	[Runde,3],[',',1],
	[Tisch,3],[',  ',3],
	['''',1],[Gefahr,12],[''',  ',4],
	['''',1],[Teiler,4],[''', ',4],
	['''',1],[NS,4],[''', ',4],
	['''',1],[OW,4],[''', ',4],
	['''',1],[Result,20],
	['  ]).',4]
	],Ausgabe),
	info(stream,Ausgabe,0),
	info(stream,nl,0).
*/
	write('res(['),
	fwrite(2,0,Board),write(' ,'),
	fwrite(2,0,Runde),write(' ,'),
	fwrite(2,0,Tisch),write(' ,'),
	writeq(Gefahr),write(' ,'),
	writeq(Teiler),write(' ,'),
	writeq(NS),write(' ,'),
	writeq(OW),write(' ,'),
	line_position(Stream,Pos),Tab is 60-Pos,tab(Tab),
	writeq(Result),write('   ]).'),        % writeq ???????????????
	nl.

fwrite(Laenge,Tab,Zahl) :- number(Zahl),!,
	zahl_laenge(Zahl,L),
	LTab is Laenge-L,
	ergaenze(Tab,A1),
	ergaenze(LTab,A2),
	write(A1),write(A2),
	write(Zahl),!.
fwrite(Laenge,Tab,Atom) :- atom(Atom),!,
	atom_laenge(Atom,L),
	LTab is Laenge-L,
	ergaenze(Tab,A1),
	ergaenze(LTab,A2),
	write(A1),write(A2),
	write(Atom),!.

zahl_laenge(Zahl,L) :- number_chars(Zahl,Liste),length(Liste,L),!.
atom_laenge(Zahl,L) :- atom_chars(Zahl,Liste),	length(Liste,L),!.

% ------------ Ende Eingabe -----------------


keinres(R) :- res(R),R=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,Points],
	Points \= n,!,fail.
keinres(_).

% ----------- PLAUSIBILITAET -------------------
plausibel :- lade('result.pl'), listing(res),
	mess_window('Es wird ein Plausibilitaets-Check durchgefuehrt.
Zum Start bitte WEITER anklicken.
Bitte haben Sie dann etwas Geduld.',[weiter],Answer),
	Answer==weiter,leere(bp),
	plausibel1,
	mess_window('Der Plausibilitaets-Check ist abgeschlossen.
Bitte kontrollieren Sie eventuelle Meldungen in der Console.',
	[weiter],_Answer1),	!.

plausibel1 :-
	Res=[_Board,Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,_Points],
	clause(runden(RR),true),el_gen(Runde,RR),
	% real_runde(Tisch,Runde,NS,OW,Boards), el_gen(Board,Boards),
	res(Res),
	plausibel(Res),
	fail.
plausibel1.

mischrunden :- leere(bp),
	generiere_zeile(['Mischrunden: '],Aus1),info(prot,Aus1,0),info(prot,nl,0),
	clause(runden(RR),true),
        % write(RR),nl,
        el_gen(Runde,RR),
        % write(teste-Runde),nl,
	once((runde(_Tisch,Runde,_NS,_OW,Boards), % el_gen(Board,Boards),
              % write(checke-runde(_Tisch,Runde,_NS,_OW,Boards)),nl,
              not((runde(_Tisch1,Runde1,_NS1,_OW1,Boards),Runde1 < Runde)))),
        % write(mischrunde-Runde-_Tisch-Boards),nl,
	generiere_zeile([Runde,'  '],Aus2),info(prot,Aus2,0),
	fail.
mischrunden :- info(prot,nl,0).

plausibel(Res) :- Res=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,n],!.
plausibel(Res) :- Res=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,p(_)],!.
plausibel(Res) :- Res=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,p(_,_)],!.
plausibel(Res) :- Res=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,p(_,_,_,_)],!.
plausibel(Res) :- Res=[Board,Runde,Tisch,Gefahr,Teiler,NS,OW,X],
        member(Funktor,[eins,zwei,drei,vier]),X=..[Funktor,Res1],!,
        plausibel([Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Res1]).
plausibel(Res) :- Res=[Board,Runde,Tisch,Gefahr,Teiler,NS,OW,Points],
	(Points is 0
	;
	% Points < 1000, Points > -1000, will Herr Funke nicht
	Res1=[Tisch,Runde,Board,Gefahr,Teiler,NS,OW,Spieler,Kontrakt,_Ausspiel,Ist,Punkte],
	member(Spieler,['Passe','N','W']),
	Kontrakt=[Hoehe,Farbe,Kontra],member(Hoehe,[1,2,3,4,5,6,7]),
	  member(Farbe,['SA','Pik','Coeur','Karo','Treff']),member(Kontra,[x,xx,' ']),
	member(Ist,[0,1,-1,2,-2,3,-3,4,-4,5,-5,6,-6,-7,-10,-9,-8,-11,-12,-13]),
	Hoehe+Ist < 8, Hoehe+Ist > -7,
	points(Res1),
	Punkte is Points	),  	!.
plausibel(Res) :- 
	Res=[Board,Runde,Tisch,_Gefahr,_Teiler,_NS,_OW,Points],
	generiere_zeile([['Runde:',7],[Runde,3],[' Tisch:',8],
	[Tisch,3],%[' NS/OW:',10],[NS,7],['/',1],[OW,7],
	[' Board:',7],[Board,4],[' Res:',5],[Points,6],['sieht komisch aus',20]],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0).

% ------------ Zwischenstand ------------------------
teilresultat :- 
	lade('result.pl'),
	% listing(res),
	leere(bp),
	teilresultat1,!.
teilresultat.

teilresultat1 :- 
	auswertung(Sol),
	show_gesamt1('Zwischenstand :',Sol),!.
% ------------ Gesamtresultat ------------------------
endresultat :-
	check_boards, % Test, ob alle Boards gespielt  TEST1
	lade('result.pl'),
	% listing(res),
	resultat,!.
endresultat.
resultat :- 
	auswertung(Sol),
	show_gesamt('Endresultat :',Sol),!.

% auf Datei gesamt.txt
endresult :- 
	leere(bp),
	check_boards, % Test, ob alle Boards gespielt  TEST1
	lade('result.pl'),
	% listing(res),
	resultat1,!.
endresult.
resultat1 :- loesche_datei('gesamt.txt'),fail.
resultat1 :- 
	auswertung(Sol),
write(fertig-Sol),nl,
	tell('gesamt.txt'),current_output(Out),
	show_gesamt('',Sol),!,
	alles_personen1,
	bresult1,
	close(Out),
	told,
	emacs('gesamt.txt').
%	message([' Fertig',' Die Resultate stehen auf gesamt.txt']).

show_gesamt(T1,R) :- show_gesamt2(stream,T1,R).
show_gesamt1(T1,R) :- show_gesamt2(bp,T1,R).
show_gesamt2(Stream,T1,R) :-
	turnier_info(Typ),
	generiere_zeile([['Platz',10],[' ',35],['Wer',10],['Punkte',8],['Proz ',10]],Ausgabe), 
	info(Stream,Ausgabe,0),	info(Stream,nl,0),
	clause(personen(P),true),
	info(Stream,T1,20),info(Stream,nl,0),
	el_gen([Platz,N,Punkte,_Max,Proz],R),
	el_gen([N,Name],P),not_dummy(N,Name),
	runde_zahl(Punkte,Punkte1,1),
	runde_zahl(Proz,Proz1,2),
	generiere_zeile([N,'  ',Name],NrName),
	once((Typ=[mitch,_], Res=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,NS,OW,_Points],
		res(Res),
		((N=NS,combine([Platz, ' NS '],Platz1)
		  ;
		  N=OW,combine([Platz, ' OW '],Platz1)
		  ))
	    ;
	    Typ \= [mitch,_],Platz1=Platz)),
	generiere_zeile([['Platz ',7],[Platz1,3],[NrName,45],[Punkte1,7],[Proz1,10],['%',1]],Ausgabe1), 
	info(Stream,Ausgabe1,0),
	info(Stream,nl,0),
	fail.
show_gesamt2(_,_,_).

% ------------ Resultat nach Personen ----------------
alles_personen :- auswertung(_), alles_personen1.

alles_personen1 :-
	clause(personen(Paare),true),
	%show_head(stream),
	el_gen([Nummer,Paar],Paare),not_dummy(_,Paar), /* dummy */
% 	frage(['Paar ',Nummer,' - ',Paar,' zeigen ? '],Taste),(Taste=quit,!,fail;Taste=ja),
	info(stream,'------------------------------------------------------------',55),info(stream,nl,0),
	info(stream,'Spieler/Paar-Nr. : ',20),
	info(stream,Nummer,4),
	info(stream,' - ',4),
	info(stream,Paar,0),info(stream,nl,0),
	show_head(stream),
	boards(Boards),
	Res=[Board,_Runde,_Tisch,_Gefahr,_Teiler,NS,OW,_Points],
	Cond=((el_gen(Board,Boards),
		(NS=Nummer;OW=Nummer
		;
		((NS=[X,Y];OW=[X,Y]),(Nummer=X;Nummer=Y))),
		search_paar(Nummer,Boards,Board,Punkte,Proz))),
	show1(Cond,Res,Punkte,Proz),
	fail.
alles_personen1.

% sucht die Boards, wo das Paar Nummer mitgespielt hat
% beim Individualturnier, wird die jeweilige Person gesucht
search_paar(Nummer,Boards,Board,Punkte,Proz1) :- 
	el_gen(Board,Boards),
	boardres(Board,Res1,_Max),
	once(((el_gen([Nummer,Punkte],Res1),Pos=left
		;
		el_gen([[Nummer,_],Punkte],Res1),Pos=left
		;
		el_gen([[_,Nummer],Punkte],Res1),Pos=right) )),
	resulteinzel(Nummer,Liste),
	member([Board,_,_,Proz2],Liste),
	
/*	prozente(Punkte,Pos,Max,Proz),
	ersetze_minusplus(Nummer,Proz,Proz2),
*/
	runde_zahl(Proz2,Proz1,1).

% ersetzt plus/minus/schnitt
ersetze_minusplus(Nummer,schnitt,Proz) :- clause(plusminus(Nummer,_,Proz,_),_),!.	
ersetze_minusplus(Nummer,minus,Proz) :- clause(plusminus(Nummer,_,_,Proz),_),!.	
ersetze_minusplus(Nummer,plus,Proz) :- clause(plusminus(Nummer,Proz,_,_),_),!.	
ersetze_minusplus(_Nummer,Proz,Proz).
% ------------ Resultat nach Boards ----------------------
alles_boards :- auswertung(_), 
	Cond=((boards(Boards),el_gen(Board,Boards),
		Res=[Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,_Points])),
	generiere_zeile([[' Board',6],['Runde',6],['Tisch',6],['Gefahr',7],
	[' NS / OW ',15],['        Resultat ',18]],Ausgabe),
	info(stream,Ausgabe,no),
	info(stream,nl,0),
	show1(Cond,Res),fail.
alles_boards.

% ------------ Resultat nach Runden ----------------------
alles_runden :- 
	auswertung(_),
	Cond=((clause(runden(Runden),true),
	el_gen(Runde,Runden),
	% real_runde(Tisch,Runde,NS,OW,Boards), el_gen(Board,Boards),
	Res=[_Board,Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,_Points])),
	generiere_zeile([[' Board',6],['Runde',6],['Tisch',6],['Gefahr',7],
	[' NS / OW ',15],['        Resultat ',18]],Ausgabe),
	info(stream,Ausgabe,no),
	info(stream,nl,0),
	show1(Cond,Res),fail.
alles_runden.

% ----------------- Resultate pro Board ------------------
% auf Console, besser auf Datei      tbd
bresult :- auswertung(_),bresult1.

bresult1 :-
	boards(Boards),el_gen(Board,Boards),
	boardres(Board,R,Max),boardfreq(Board,Freq),
%	frage(['Board ',Board,' zeigen ? '],Taste),(Taste=quit,!,fail;Taste=ja),*/
	Cond=((Res=[Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,_Points])),
	info(stream,'----------------------------------',35),info(stream,nl,0),
	info(stream,'Board-Nr. ',12),info(stream,Board,4),info(stream,nl,0),
	show_head(stream),
	show1(Cond,Res), % info(stream,nl,0),
	show_br('Punkte fuer Board : ',Board,R,Max),
	show_freq('----> Frequenzen fuer Board ',Board,Freq),
	fail.
bresult1 :-
        once((clause(strafe(_,_),_))),
	info(stream,nl,0),info(stream,nl,0),
        info(stream,'----------------------------------',35),info(stream,nl,0),
        info(stream,nl,0),
	info(stream,'Strafen',10),info(stream,nl,0),
        strafe(Wer, Was),
	info(stream,'Spieler/Paar: ',15),info(stream,Wer,4),
	info(stream,'Welche: ',10),info(stream,Was,8),info(stream,nl,0),
        fail.
bresult1. 

show_br(Text1,Board,R,Max) :-
	clause(personen(P),true),
	info(stream,Text1,20),info(stream,Board,4),info(stream,nl,0),
	(el_gen([N,Punkte],R),Pos=left
	 ;
	 el_gen([Paar,Punkte],R),(Paar=[N,_],Pos=left;Paar=[_,N],Pos=right)),
	el_gen([N,Name],P),not_dummy(N,Name),
	once((Punkte=..[p|_],prozente(Punkte,Pos,max,Proz),
		% Ersetzen eventueller Minus/Plus-Resultate 
		ersetze_minusplus(N,Proz,Proz2),runde_zahl(Proz2,Proz1,1),
		info(stream,Proz1,13);
		prozente(Punkte,Pos,Max,Proz),info(stream,Punkte,5),
			runde_zahl(Proz,Proz1,1),info(stream,Proz1,8))),
	info(stream,' %  ',4),
	info(stream,N,2),info(stream,' ',1),info(stream,Name,0),info(stream,nl,0),fail.
show_br(_,_,_,_).


/*
	resulteinzel(Nummer,Liste),
	member([Board,_,_,Proz2],Liste),
	runde_zahl(Proz2,Proz1,1).
*/


show_freq(Titel,Board,Freq) :-
	%info(stream,nl,0),
	info(stream,Titel,35),info(stream,Board,4),info(stream,nl,0),
	generiere_zeile([['Resultat ',23],['Anzahl ',10],['Proz NS ',9],['Proz OW ',9]],Ausgabe),
	info(stream,Ausgabe,no),
	info(stream,nl,0),
	show_freq1(Freq).
show_freq1([]) :- !.
show_freq1([[Anzahl,Punkte,NS,OW]|T2]) :-
	info(stream,Punkte,20),info(stream,Anzahl,10),
	(number(NS),runde_zahl(NS,NS1,1);NS=NS1),info(stream,NS1,9),
	(number(OW),runde_zahl(OW,OW1,1);OW=OW1),info(stream,OW1,9),
	info(stream,nl,0),
	!,
	show_freq1(T2).


% Ohne Turnierpunkte
show1(Cond,Res) :-
	Res=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,_Points],
	Cond,   res(Res),
	% once((real_runde(Tisch,Runde,NS,OW,Boards),el_gen(Board,Boards))),
	show_res(Res),
	fail.
show1(_,_).
% mit Turnierpunkten
show1(Cond,Res,Punkte,Proz) :-
	Res=[_Board,_Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,_Points],
	Cond,   res(Res),
	% once((real_runde(Tisch,Runde,NS,OW,Boards),el_gen(Board,Boards))),
	show_res(Res,Punkte,Proz),
	fail.
show1(_,_,_,_).

% ---------------------- Zuruecksetzen von Daten ------------------------
reset_basics :-
	kill(personen(_)),kill(persons(_)),kill(turnier_info(_)),
	kill(rundenzahl(_)),kill(boardsprorunde(_)).

myreset :- reset1,!.
reset.

reset1 :- frage(['Alle Daten werden geloescht ! ','Sind Sie sicher ? '],Taste1),
	  (Taste1\==ja,!,fail;Taste1==ja),reset2.

reset2 :- kill(persons(_)),kill(boardsprorunde(_)),kill(rundenzahl(_)),
	kill(boards(_)),kill(runde(_,_,_,_,_)),kill(resulteinzel(_,_)),
	kill(personen(_)),kill(turnier_info(_)),kill(form(_)),
	kill(plusminus(_,_,_,_)),
	set_data,	
	lade(brgefahr),!.

reset_result_all :- kill(res(_)),kill(strafe(_,_)),
	reset_datei('result.pl'),reset_result,!.
reset_result :- 
	kill(plusminus(_,_,_,_)),kill(boardres(_,_,_)),kill(boardfreq(_,_)),
	kill(resulteinzel(_,_)),kill(result(_)).
reset_board_result(B) :- kill(plusminus(_,_,_,_)),kill(result(_)),
	kill(resulteinzel(_,_)),retract_once(boardres/3,boardres(B,_,_)),!.

dynamisch :-
	dynamic(boardres/3),
	dynamic(result/1),
	% dynamic(form/1),
	dynamic(boardsprorunde/1),
	dynamic(persons/1),
	dynamic(personen/1),
	dynamic(rundenzahl/1),
	dynamic(plusminus/4),
	dynamic(boards/1),
	dynamic(runde/5),
	dynamic(runden/1), 
	dynamic(turnier_info/1),
	dynamic(res/1), 
	dynamic(strafe/2), 
%	dynamic(beginn/2), 
%	dynamic(spezi/3),
	dynamic(geo/3),
	dynamic(resulteinzel/2).

leer_turnier :-
        kill(strafe(_,_)),klausel_insert(strafe(200000000000000,p(5))),
	kill(turnier_info(_)),klausel_insert(turnier_info(haha)),
	kill(persons(_)),klausel_insert(persons(17)),
	kill(boardsprorunde(_)),klausel_insert(boardsprorunde(2)),
	kill(boards(_)),klausel_insert(boards([1,2])),
	kill(rundenzahl(_)),klausel_insert(rundenzahl(18)),!,
	kill(form(_)), klausel_insert(form(paar)),
	kill(res(_)),klausel_insert(res([1,2,3,test])),
	kill(personen(_)),klausel_insert(personen([a,b])),
	kill(boardres(_,_,_)),klausel_insert(boardres(1,1,1)),
	kill(resulteinzel(_,_)),klausel_insert(resulteinzel(1,[])),
	kill(plusminus(_,_,_,_)),klausel_insert(plusminus(1,80,20,50)),
	kill(result(_)),klausel_insert(result([])),
	quelldir(Dir),combine([Dir,'ho3-5-2'],File),lade(File).

% ---------- ENDE ------ Zuruecksetzen von Daten ------------------------

% ------------------- TEST auf VOLLSTAENDIGKEIT --------------
complete :- leere(bp),check_boards,!,
	info(prot,'Es fehlen keine Boards, komplett gespielt ',40),
	info(prot,nl,0).
complete.

% ---- Test, ob Boards schon vollstaendig gespielt ist 
check_boards :- lade('result.pl'), % listing(res),
	clause(boards(B),true),el_gen(Board,B),board_fehlt(Board),!,fail.
check_boards.

% ----------- Tests, ob Board vollst. oder nicht ------------------------
board_fehlt(Board) :- board_complete(Board),!,fail.
board_fehlt(_Board). 

board_complete(Board) :- board_fehlt1(Board),!,fail.
board_complete(_Board).

% board_fehlt1(Board) :- Res=[Board,Runde,Tisch,_Gefahr,_Teiler,NS,OW,_Points],
%	clause(runden(RR),true),el_gen(Runde,RR),
%	real_runde(Tisch,Runde,NS,OW,Boards),
%	el_gen(Board,Boards),keinres(Res),
%	prepare(NS,NSS), prepare(OW,OWW),
%	generiere_zeile([['Es fehlt:',10],[' Runde:',8],[Runde,4],[' Tisch:',8],
%	[Tisch,3],[' NS/OW:',8],[NSS,5],['/',1],[OWW,5],
%	[' Board:',7],[Board,8]],Ausgabe),
%	info(prot,Ausgabe,no),
%	info(prot,nl,0).

% NEU Ich schau nur noch nach, ob eine res-Klausel mit n existiert 
board_fehlt1(Board) :- Res=[Board,Runde,Tisch,_Gefahr,_Teiler,NS,OW,_Points],
	clause(runden(RR),true),el_gen(Runde,RR),
	% real_runde(Tisch,Runde,NS,OW,Boards), el_gen(Board,Boards),
        res(Res),keinres(Res),
	prepare(NS,NSS), prepare(OW,OWW),
	generiere_zeile([['Es fehlt:',10],[' Runde:',8],[Runde,4],[' Tisch:',8],
	[Tisch,3],[' NS/OW:',8],[NSS,5],['/',1],[OWW,5],
	[' Board:',7],[Board,8]],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0).

prepare([A,B],X) :- !,combine([A,'+',B],X).
prepare(X,X).

% -------------- Tests, ob Tisch vollst. oder nicht ---------------------
tisch_fehlt(Tisch,Res) :- tisch_complete(Tisch,Res),!,fail.
tisch_fehlt(_Tisch,_Res).

tisch_fehlt1(Tisch,Res) :-
	Res=[_Board,_Runde,Tisch,_Gefahr,_Teiler,_NS,_OW,_Points],
	% real_runde(Tisch,Runde,NS,OW,Boards), el_gen(Board,Boards),
        res(Res),keinres(Res).

tisch_complete(Tisch,Res) :-tisch_fehlt1(Tisch,Res),!,fail.
tisch_complete(_,_).

% ---------------- Tests, ob Runde vollst. oder nicht --------------------
runde_fehlt(Runde,Res) :- runde_complete(Runde,Res),!,fail.
runde_fehlt(_Runde,_Res).

runde_fehlt1(Runde,Res) :-
	Res=[_Board,Runde,_Tisch,_Gefahr,_Teiler,_NS,_OW,_Points],
	% real_runde(Tisch,Runde,NS,OW,Boards), el_gen(Board,Boards),
        res(Res),keinres(Res).

runde_complete(Runde,Res) :- runde_fehlt1(Runde,Res),!,fail.
runde_complete(_Runde,_Res).

% ----------------- ENDE TEST VOLLSTAENDIGKEIT -----------------

% ----------------- Hilfe zum Tische platzieren -------------------
max_tisch(Tisch) :- real_runde(Tisch,_,_,_,_),not((real_runde(Tisch1,_,_,_,_),Tisch1 > Tisch)),!.

tischeplatzieren :-
      darf, 
      darfnicht.
darf :-
	leere(bp),generiere_zeile(['----- Hilfe zum Platzieren der Tische (Testversion) ----'],Aus),
        info(prot,Aus,0),info(prot,nl,0),
	max_tisch(MT),
        gener_list(1,MT,TListe),
        member(Tisch,TListe),Tisch < MT,
        member(T2,TListe),Tisch < T2,
        vertraeglich(Tisch,T2),        vertraeglich(T2,Tisch),
	generiere_zeile(['Tische ',Tisch,' und ',T2,' duerfen benachbart sein.'],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0),
	fail.
darf.

darfnicht :-
%	leere(bp),generiere_zeile(['----- Hilfe zum Platzieren der Tische (Testversion) ----'],Aus),
%        info(prot,Aus,0),info(prot,nl,0),
	max_tisch(MT),
        gener_list(1,MT,TListe),
        member(Tisch,TListe),Tisch < MT,
        member(T2,TListe),Tisch < T2,
        (not(vertraeglich(Tisch,T2));not(vertraeglich(T2,Tisch))),
	generiere_zeile(['Tische ',Tisch,' und ',T2,' duerfen NICHT benachbart sein.'],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0),
	fail.
darfnicht.

vertraeglich(Tisch,T2) :-
        not((
           real_runde(Tisch,Runde,NS,OW,_),
           real_runde(T2,Runde,_,_,Board2),
           real_runde(_,R3,NS3,OW3,Board2),
           gemeinsame_spieler([NS,OW],[NS3,OW3]),
           R3 is Runde+1)),!.

gemeinsame_spieler([NS,OW],[NS2,OW2]) :- 
        (X = NS ; X = OW ; member(X,NS);member(X,OW)),
        (X = NS2 ; X = OW2 ; member(X,NS2);member(X,OW2)),!.

% ----------------- Hoechste Runde pro Board -------------------
boardsfertig :-
	leere(bp),generiere_zeile(['----- Wann sind Boards fertig --------------'],Aus),info(prot,Aus,0),info(prot,nl,0),
	clause(boards(B),true),el_gen(Board,B),
	real_runde(Tisch,Runde,_,_,Boards),el_gen(Board,Boards),
	not((
		real_runde(_,Runde1,_,_,Boards1),el_gen(Board,Boards1),Runde1>Runde
		)),
        once((Board < 10,B1=' ';B1='')),
	generiere_zeile(['Board ',B1,Board,' hoechste Runde ', Runde,'   an Tisch ',Tisch],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0),
	fail.
boardsfertig.

% ----------------- Erste Runde pro Board -------------------
boardsfirst :-
	leere(bp),generiere_zeile(['----- Wann werden Boards das 1. Mal gespielt -----'],Aus),
        info(prot,Aus,0),info(prot,nl,0),
	clause(boards(B),true),el_gen(Board,B),
	real_runde(Tisch,Runde,_,_,Boards),el_gen(Board,Boards),
	not((
		real_runde(_,Runde1,_,_,Boards1),el_gen(Board,Boards1),Runde1<Runde
		)),
        once((Board < 10,B1=' ';B1='')),
	generiere_zeile(['Board ',B1,Board,' erste Runde ', Runde,'   an Tisch ',Tisch],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0),
	fail.
boardsfirst.

% ----------------- Wer spielt welches Board NICHT -------------------
boardsnicht :-
	not(clause(personen(_),_)),
	generiere_zeile(['Geben Sie zunaechst die Personen ein.'],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0),fail.
boardsnicht :-
	clause(personen(Personen),_),
	leere(bp),generiere_zeile(['----- Wer spielt welches Board NICHT --------------'],Aus),
        info(prot,Aus,0),info(prot,nl,0),
	clause(boards(B),true),el_gen(Board,B),
	member([Nr,Person],Personen),Person\=dummy,
        not((
            real_runde(_Tisch,_Runde,NS,OW,BoardListe),el(Board,BoardListe),
            once((member(Nr,[NS,OW]);member(Nr,NS);member(Nr,OW))))),
	generiere_zeile(['Board ',Board,' wird nicht gespielt von ', Person],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0),
	fail.
boardsnicht.

% ---------- +++++ ----------- AUSWERTUNG ------------- +++++ -----------
auswertung(Sol) :-
	% Test auf Vollstaendigkeit habe ich rausgenommen, TEST1
	% check_boards, % Test, ob alle Boards gespielt
	% Schritt 1 : Boards zusammenfassen
	count_boards,
	% Schritt 2 : Punkte den Personen zuordnen
	accu_persons(Sol).

% -------------- BOARDBEWERTUNG berechnen ----------------------
% generiert die Fakten zu
%     boardres(Board,PR2,Max)      und   boardfreq(Board,Freq)
% benoetigt: real_runde

count_boards :- reset_result,
	clause(boards(B),true),   el_gen(Board,B),
	count_board(Board,_PaarRes),   fail.
count_boards.

    % Fuer dieses Board wurde die Berechnung bereits durchgefuehrt
count_board(Board,PaarRes) :- clause(boardres/3,boardres(Board,PaarRes,_Max)),
	reset_board_result(Board),fail.
% Normalfall
count_board(Board,_PaarRes) :-
	board_complete(Board),  % Test, ob Board komplett gespielt
        % kein verfaelschtes Board
	not((Res=[Board,Runde,Tisch,_Gefa,_Tei,NS,OW,eins(_)],res(Res))),
        write(Board-'KEIN VERFAELSCHTES BOARD'),nl,!,
	Res=[Board,Runde,Tisch,_Gefahr,_Teiler,NS,OW,Points],
	% 1. Schritt: Liste aller Punkte fuer das Board: Board
	% Resultat ist eine Liste der Form :
	% [[alloc, p(minus), [7, 11], [8, 3]], ... 7/11 gegen 8/3 mit Resultat p(minus)
	%  [alloc, p(plus, minus), [4, 14], [6, 13]],
	%  [alloc, p(plus, minus, minus, plus), [2, 5], [12, 1]]]
	%   ALT Call=((real_runde(Tisch,Runde,NS,OW,Boards),el_gen(Board,Boards),res(Res))),
	Call=((res(Res))),
	all(Call,[alloc,Points,NS,OW],L1Org,sol),
        write(Board-'EINS'-L1Org),nl,
	% 2. Schritt: Ersetzen der kuenstlichen Boardresultate durch 12345
	%        (falls Turnierleitung Prozente oder plus/minus festlegte)
	% Resultat ist eine Liste der Form
	% [[alloc, 12345, [7, 11], [8, 3]], 
	%  [alloc, 12345, [4, 14], [6, 13]],
	%  [alloc, 12345, [2, 5], [12, 1]]]
	% sowie die Anzahl der Korrekturen: 3
	ersetze_korrigierte_resultate_durch_12345(L1Org,L11,AnzahlKorr),
        write(Board-'ZWEI'-L11),nl,
	% 3. Schritt: Sortieren nach Punkten, 
	%     korrigierte Resultate stehen vorn als 12345 !!
	ssort(L11,L2),
        write(Board-'DREI'-L2),nl,
	% 4. Schritt: Zuordnen der Match-Punkte --> Alloc
	% Resultat ist eine Liste der Form
	% [1*[p(minus), p(minus), p(minus)], 
	%  1*[p(plus, minus), p(plus), p(minus)], 
	%  1*[p(plus, minus, minus, plus), p(plus, minus), p(minus, plus)]]
	% oder
	% [1*[200, 4, 0], 2*[100, 1, 3]]
	alloc_points(L2,Alloc, AnzahlKorr, L1Org, Max),
        write(Board-'VIER'-Alloc),nl,
	% 5. Schritt: Zuordnen der Punkte zu den Personen
	% Resultat ist eine Liste der Form:
	% [[[7, 11], p(minus)], [[2, 5], p(plus, minus)], 
	%  [[4, 14], p(plus)], [[8, 3], p(minus)], 
	%  [[12, 1], p(minus, plus)], [[6, 13], p(minus)]]
	% oder
	% [[[5, 12], 4], [[4, 2], 3], [[10, 13], 3], [[15, 8], 1],
	% [[7, 9], 1], [[3, 11], 0]]
	alloc_points_to_persons(L2,Alloc,L1Org,ResBoard),
	ssort(ResBoard,PR2),
	assert(boardres(Board,PR2,Max)),
        write(Board-'FUENF'-PR2-Max),nl,
	% 6. Berechnen der Boardfrequenzen
	count_frequencies(Alloc,Max,Freq),
	assert(boardfreq(Board,Freq)),
        write(Board-'SECHS'-Freq),nl.

% Sonderfall der verfaelschten Boards
% Es gibt dann Resultate der Form eins(100) und zwei(p(minus))
% Die Gruppen werden mit den Funktoren eins/zwei/drei/vier gekennzeichnet.
count_board(Board,_PaarRes) :-
	board_complete(Board),  % Test, ob Board komplett gespielt
        % Es gibt ein Resultat mit dem Funktor eins(...)
	not(not((Res=[Board,Runde,Tisch,_Ge,_Te,NS,OW,eins(_)],res(Res)))),
        write('Verfaelschtes Board'),nl,!,
	Res=[Board,Runde,Tisch,_Gefahr,_Teiler,NS,OW,Points],
	% 1. Schritt: Liste aller Punkte fuer das Board: Board
	% Resultat ist eine Liste der Form :
	% [[alloc, eins(100), [7, 11], [8, 3]], ... 7/11 gegen 8/3 mit Resultat 100
	%  [alloc, eins(p(plus, minus)), [4, 14], [6, 13]],
	%  [alloc, zwei(p(plus, minus, minus, plus)), [2, 5], [12, 1]], ... Zweite Gruppe
	%  [alloc, zwei(-50), [2, 5], [12, 1]]] ... Zweite Gruppe
	Call=((res(Res))),
	all(Call,[alloc,Points,NS,OW],L1Org,sol),
        write(Board-'EINS'-L1Org),nl,
        % 1b. Schritt: Trennen der Gruppen bezueglich eins/zwei/ ...
        verf_boards_trennen([eins,zwei,drei,vier],L1Org,L11),
        write(Board-'EINSB-TRENNEN'-L11),nl,
	% 2. Schritt: Ersetzen der kuenstlichen Boardresultate durch 12345
	%        (falls Turnierleitung Prozente oder plus/minus festlegte)
	% Resultat sind Listen der Form
	% [[alloc, 12345, [7, 11], [8, 3]], 
	%  [alloc, 12345, [4, 14], [6, 13]],
	%  [alloc, 12345, [2, 5], [12, 1]]]
	% sowie die Anzahl der Korrekturen: 3
        % Originalliste wird ebenso gespeichert: [[12345Liste,OrigListe,AnzKorr],...]
	Call2=((member(Liste,L11),once((ersetze_korrigierte_resultate_durch_12345(Liste,L11a,AnzahlKorr))))),
	all(Call2,[L11a,Liste,AnzahlKorr],L11b,sol),
        write(Board-'ZWEI'-L11b),nl,
	% 3. Schritt: Sortieren nach Punkten, 
	%     korrigierte Resultate stehen vorn als 12345 !!
	Call3=((member([LV3,Liste,Korr],L11b),once((ssort(LV3,L2))))),
	all(Call3,[L2,Liste,Korr],L2b,sol),
        write(Board-'DREI'-L2b),nl,
	% 4. Schritt: Zuordnen der Match-Punkte --> Alloc
	% Resultat ist eine Liste der Form
	% [1*[p(minus), p(minus), p(minus)], 
	%  1*[p(plus, minus), p(plus), p(minus)], 
        %  2*[100, 1, 3],
	%  1*[p(plus, minus, minus, plus), p(plus, minus), p(minus, plus)]]
	Call4=((member([LV4,Liste,Korr],L2b),once((alloc_points(LV4,Alloc1, Korr, Liste, Max))))),
	all(Call4,[LV4,Liste,Alloc1,Korr,Max],Alloc,sol),
        write(Board-'VIER'-Alloc),nl,
	% 5. Schritt: Zuordnen der Punkte zu den Personen
	% Resultat sind Listen der Form:
	% [[[7, 11], p(minus)], [[2, 5], p(plus, minus)], 
	%  [[4, 14], p(plus)], [[8, 3], p(minus)], 
	%  [[12, 1], p(minus, plus)], [[6, 13], p(minus)]]
	% oder
	% [[[5, 12], 4], [[4, 2], 3], [[10, 13], 3], [[15, 8], 1],
	% [[7, 9], 1], [[3, 11], 0]]
	Call5=((member([LV5,LOrig5,Alloc5,_Korr5,_Max5],Alloc),
             once((alloc_points_to_persons(LV5,Alloc5,LOrig5,ResBoard))))),
	all(Call5,ResBoard,PunktL,sol),
        write(Board-'FUENF'-PunktL),nl,
	% 6. Schritt: Korrigieren der Resultate
	% Prozente bleiben Prozente
	% Matchpunkte werden um die Anzahl der in den jeweilig anderen Gruppen gespielten Spiele erhoeht
        length(L1Org,GesamtAnzahl),
        % write(Board-'ANZAHL'-GesamtAnzahl),nl,
	Call5a=((member(Gruppe5,PunktL),member([SpielerPaar5,Punkte5],Gruppe5),
                 length(Gruppe5,LVL5),
                 once((form(paar),N5 is GesamtAnzahl-(LVL5/2)
                       ;
                       form(individual),N5 is GesamtAnzahl-(LVL5/4))),
                 once((Punkte5=p(_),Punkte5neu=Punkte5 ; Punkte5neu is Punkte5 + N5)))),
	all(Call5a,[SpielerPaar5,Punkte5neu],ResBoard2,sol),
        write(Board-'FUENFA'-ResBoard2),nl,
%
	ssort(ResBoard2,PR2),
%
        % nun werden fuer die Frequenzen die Punkte entsprechend erhoeht
        Call5b=((member([_,_,Alloc5b,_,_],Alloc),
                 berechne_anzahl(Alloc5b,AN),member(N5b*[Res5b,NSPunkte,OWPunkte],Alloc5b),
                 once((NSPunkte=p(_),NSPNeu=NSPunkte ; NSPNeu is NSPunkte+GesamtAnzahl-AN)),
                 once((OWPunkte=p(_),OWPNeu=OWPunkte ; OWPNeu is OWPunkte+GesamtAnzahl-AN))
               )),
	all(Call5b,N5b*[Res5b,NSPNeu,OWPNeu],Freq1,sol),
        write(Board-'FUENFB'-Freq1),nl,
%
	Max is 2*GesamtAnzahl-2,  % Absolutes Maximum
	assert(boardres(Board,PR2,Max)),
        write(Board-'SECHS'-PR2-Max),nl,
%
	% 7. Berechnen der Boardfrequenzen
        % Alloc flach machen
        % Call7=((member([_,_,Alloc1,_,_],Alloc),member(EinResultat,Alloc1))),
	% all(Call7,EinResultat,ResBoard3,sol),
	% count_frequencies(ResBoard3,Max,Freq),
	count_frequencies(Freq1,Max,Freq),
	assert(boardfreq(Board,Freq)),
        write(Board-'SIEBEN'-Freq),nl.

count_board(Board,_PaarRes) :- % TEST1
	generiere_zeile([['Noch nicht komplettes Board:',25],[Board,4]],Ausgabe),
	info(prot,Ausgabe,no),
	info(prot,nl,0),
	fail.

berechne_anzahl([],0) :- !.
berechne_anzahl([N*_|Rest],Anzahl) :-
        berechne_anzahl(Rest,N1),
        Anzahl is N+N1.

verf_boards_trennen([],_,[]) :- !.
verf_boards_trennen([Funktor|Rest],L1Org,[FL|L11]) :-
        Term =.. [Funktor,Punkte],
%	Res=[Board,Runde,Tisch,_Gefahr,_Teiler,NS,OW,Term],
%	Call=((res(Res))),
	Call=((member([alloc,Term,NS,OW],L1Org))),
	all(Call,[alloc,Punkte,NS,OW],FL,sol),
        FL \= [],!,
        verf_boards_trennen(Rest,L1Org,L11).
verf_boards_trennen([_|Rest],L1Org,L11) :-
        verf_boards_trennen(Rest,L1Org,L11).

ersetze_korrigierte_resultate_durch_12345([],[],0) :- !.
ersetze_korrigierte_resultate_durch_12345([[A,Res,C,D]|Rest],[[A,12345,C,D]|R1],Anzahl) :-
	(Res=p(_);Res=p(_,_);Res=p(_,_,_,_)),!,
	ersetze_korrigierte_resultate_durch_12345(Rest,R1,Anz),Anzahl is Anz+1.
ersetze_korrigierte_resultate_durch_12345([X|Rest],[X|R1],Anzahl) :-
	ersetze_korrigierte_resultate_durch_12345(Rest,R1,Anzahl).

loesche_korrigierte_resultate([],[],0) :- !.
loesche_korrigierte_resultate([[_A,Res,_C,_D]|Rest],R1,Anzahl) :-
	(Res=p(_);Res=p(_,_);Res=p(_,_,_,_)),!,
	loesche_korrigierte_resultate(Rest,R1,Anz),Anzahl is Anz+1.
loesche_korrigierte_resultate([X|Rest],[X|R1],Anzahl) :-
	loesche_korrigierte_resultate(Rest,R1,Anzahl).

count_frequencies([],_,[]) :- !.
count_frequencies([(N*[Punkte,NS,OW])|T2],Max,[[N,Punkte,NS1,OW1]|T3]) :-
	Punkte =.. [p|_],!,
	trans_penalty(NS,NS1), % Prozente einsetzen
	trans_penalty(OW,OW1),
	count_frequencies(T2,Max,T3).
count_frequencies([(N*[Punkte,NS,OW])|T2],Max,[[N,Punkte,NS1,OW1]|T3]) :-
	prozente(NS, left,Max, NS1),
	prozente(OW, left,Max, OW1),
%	OW1 is 100-NS1,
	count_frequencies(T2,Max,T3).

% falls die Prozente als p(...) ankommen
prozente(p(Proz),_,_Max,Proz) :- !.
prozente(p(Proz,_),left,_Max,Proz) :- !.
prozente(p(_,Proz),right,_Max,Proz) :- !.
prozente(_NS,_,0,0) :- !.
prozente(NS,_,Max,NS1) :- NS1 is 100 * NS / Max.
%prozente(NS,_,Max,NS1) :-
%	NS2a is (10000 * (NS + 0.00005*Max)) / Max, 
%	NS2 is truncate(NS2a),
%	NS1 is NS2/100.

% Berechnung der Punkte fuer die Resultate eines Boards
% Eventuell korrigierte Resultate stehen hier noch als 12345, also als Top fuer NS drin.
%   ZB :   1 - 2   6   2
%          3 - 4   4   4
%          5 - 6   2   6
%          7 - 8  20%  20%  korrigiertes Paar
alloc_points(L,Alloc, AnzahlKorr, L1Org, Max1) :- length(L,Length),
	Max1 is 2*Length-2,  % Absolutes Maximum
	Max is 2*(Length-AnzahlKorr)-2, % Maximum ohne korr. Resultate
	L=[[alloc,F,_NS,_OW]|T],
	alloc(T,F,1,Max,Max,Alloc1),
	% nun muss auf alle NS 1*Korrekturen draufaddiert werden
	%  und die 12345 wieder durch die korrigierten ersetzt werden
	Korr is 1*AnzahlKorr, % es gibt nur 1 Punkt nicht 2
	% und zwar bekommt man fuer jedes Resultat, was gleich ist, oder mit dem man sich 
	% nicht vergleichen kann, 1 Punkt
	alloc_correct(Alloc1,Korr,L1Org,Alloc).

alloc_correct([],_,_,[]) :- !.
alloc_correct([(N*_)|RestAlloc1],Korr,L1Org,Alloc) :- N =0,!,
	alloc_correct(RestAlloc1,Korr,L1Org,Alloc).
alloc_correct([(N*[12345,NS,OW])|RestAlloc1],Korr,L1Org,[(1*[X,NS1,OW1])|Alloc]) :- !,
	member([alloc,X,_,_],L1Org),X=..[p|_],del([alloc,X,_,_],L1Org,L1Org2),!,
	trans_penalty(X,NS1,OW1),
	N1 is N-1,
	alloc_correct([(N1*[12345,NS,OW])|RestAlloc1],Korr,L1Org2,Alloc).
alloc_correct([(N*[Res,NS,OW])|RestAlloc1],Korr,L1Org,[(N*[Res,NS1,OW1])|Alloc]) :- !,
	NS1 is NS+Korr,OW1 is OW+Korr,
	alloc_correct(RestAlloc1,Korr,L1Org,Alloc).

trans_penalty(p(N) , p(N), p(N)) :- !.
trans_penalty(p(NS,OW) , p(NS), p(OW)) :- !.
trans_penalty(p(N,S,O,W) , p(N,S), p(O,W)).

trans_penalty(p(N) , N) :- !.
trans_penalty(p(N1,N2) , [N1,N2]) :- !. % fuer Individual


% Liste der Resultate,Vergleichsresultat, Zahl der bisher gefunden
%	gleichen Vergleichsresultate, Punkte, Max.punkte, Resultat
% alloc ignoriert die korrigierten Resultate total
alloc([[alloc,F,_X,_Y]|T],12345,_N,Points,Max,[(1*[12345,0,0])|T1]) :-  !,
	alloc(T,F,1,Points,Max,T1).
alloc([],First,N,Points,Max,[(N*[First,NS,OW])]) :-
	NS is Points-N+1, OW is Max-NS,!.
alloc([[alloc,First,_,_]|T],First,N,Points,Max,T1) :- !,
	N1 is N+1,
	alloc(T,First,N1,Points,Max,T1).
alloc([[alloc,F,_,_]|T],First,N,Points,Max,[(N*[First,NS,OW])|T1]) :- 
	NS is Points-N+1, OW is Max-NS, P2 is Points - N*2,
	alloc(T,F,1,P2,Max,T1).

alloc_points_to_persons([],_,_,[]) :- !.
alloc_points_to_persons(T1,[(0*[_F1,_N1,_N2])|T2],L1Org,T3) :- !,
	alloc_points_to_persons(T1,T2,L1Org,T3).
alloc_points_to_persons(T1,[(N*[Res,N1,N2])|T2],L1Org,[[NS,N1],[OW,N2]|T3]) :-
	Res =.. [p|_],!,NN is N-1,
	del([alloc,Res,NS,OW],L1Org,L1Org2),
	del([alloc,12345,NS,OW],T1,T11),
	alloc_points_to_persons(T11,[(NN*[Res,N1,N2])|T2],L1Org2,T3).
alloc_points_to_persons([[alloc,_,NS,OW]|T1],[(N*[F1,N1,N2])|T2],L1Org,[[NS,N1],[OW,N2]|T3]) :-
	NN is N-1,
	alloc_points_to_persons(T1,[(NN*[F1,N1,N2])|T2],L1Org,T3).

% ---------------------------------------------------
% Zuweisung der Prozent-Punkte zu den Paaren
% Rueckgabewert: Resultatsliste
% 
% benoetigt: boardres / 3
% liefert: plusminus/4 .... PlusMinus-Durchschnitt jeder Person
% resulteinzel / 2
% 
accu_persons(S2) :- 
	kill(resulteinzel(_,_)),
	kill(plusminus(_,_,_,_)),
	C1=((   personen(Pairs),el_gen([N,_],Pairs),not_dummy(N,_),
		Call=((boardres(Board,Liste,Max),
			(el_gen([N,Points],Liste),Pos=left  /* Paarturnier */
			 ;
			 el_gen([Paar,Points],Liste),
			 (Paar=[N,_],Pos=left;Paar=[_,N],Pos=right))  /* Individual */ 
		     )),
		all(Call,[Board,Points,Max,Pos],Sol,sol1),
		% write(N-Sol),nl,
		% addiere alle Punkte auf
		% Dabei werden alle kuenstlichen Bewertungen beruecksichtigt
		% ListeNeu ist die Liste aller Spieler/Paare, in denen auch 
		%  plus/minus-Bestrafungen schon beruecksichtigt wurden 
		addiere(Sol,Summe,Max,Plus,Minus,Schnitt,ListeNeu), 
		assert(plusminus(N,Plus,Schnitt,Minus)),
		write(accu-N-ListeNeu),nl,
		write(accu-N-plus-Plus-schnitt-Schnitt-minus-Minus),nl,
		calc_procent(ListeNeu,ListeNeu2),
		write(accu-N-ListeNeu2),nl,
		assert(resulteinzel(N,ListeNeu2)),
		prozente(Summe,left,Max,Proz) )),
	all(C1,[N,Summe,Max,Proz],S,sol2),
%nl,nl,
%write(vor-strafe-S),nl,nl,
        strafen(S,Straf), % eventuell kuenstliche Strafen beruecksichtigen
%write(nachstrafe-S-Straf),nl,
	ssort(Straf,S1),
	platzierung(S1,S2),assert((result(S2))).

calc_procent([],[]) :- !.
calc_procent([[Board,Res,Res2,Max,Pos]|T],
	     [[Board,orig(Pos,Res,Res2),Max,Proz]|T1] ) :-
	berechne_prozente(Res2,Pos,Max,Proz),
	calc_procent(T,T1).

% loest kuenstliche Scores auf und liefert Prozentzahl zurueck
%     noch nicht gerundet
berechne_prozente(Res2,Pos,Max,Proz) :-
	prozente(Res2,Pos,Max,X),
/*	once(((Res2=p(X,_),Pos=left
		;
		Res2=p(_,X),Pos=right
		;
		Res2=p(X),Pos=_
		;
		Res2=X,Pos=_))),
		*/
	loesche_plusminusfunktor(X,Proz).

loesche_plusminusfunktor(plus(X),X) :- !.
loesche_plusminusfunktor(minus(X),X) :- !.
loesche_plusminusfunktor(schnitt(X),X) :- !.
loesche_plusminusfunktor(X,X).

% Strafen beruecksichtigen, alle im Format strafe(WER, WAS), bisher nur als p(PROZ)

strafen(Sol, Sol1) :-
        clause(strafe(_,_),_),!,
	Call=strafe(Wer,Strafe),
	all(Call,[Wer,Strafe],Strafen,pena),
        korrigiere_res(Sol, Strafen, Sol1).
strafen(Sol, Sol).

korrigiere_res([], _, []) :- !.
korrigiere_res([[Spieler,Punkte,MaxPunkte, Proz]|S1], Strafen, Liste) :-
        del([Spieler,Was],Strafen,Strafen1),
        Was = p(MinusProz),
        Proz1 is Proz-MinusProz,!,
        korrigiere_res([[Spieler,Punkte,MaxPunkte, Proz1]|S1], Strafen1, Liste).
korrigiere_res([[Spieler,Punkte,MaxPunkte, Proz]|S1], Strafen, [[Spieler,Punkte,MaxPunkte, Proz]|S2]) :-
        korrigiere_res(S1, Strafen, S2).

% --------------

platzierung(S1,S2) :-
%	S1 = [[Spieler,Punkte,MaxPunkte, Proz]|_],
	platziere(S1,120,0,0,S2).
	
platziere([],_,_,_,[]) :- !.
platziere([[Spieler,Punkte,MaxPunkte, Proz]|S1], Proz,Platz,Bisher,
	[[Platz,Spieler,Punkte,MaxPunkte,Proz]|S2]) :- !,
	Bisher1 is Bisher+1,
	platziere(S1,Proz,Platz,Bisher1,S2).
platziere([[Spieler,Punkte,MaxPunkte, Proz]|S1], _,Platz,Bisher,
	[[Platz1,Spieler,Punkte,MaxPunkte,Proz]|S2]) :-
	Platz1 is Platz+Bisher+1,
	platziere(S1,Proz,Platz1,0,S2).

% addiert auf dem 2. Parameter alle Punkte
% auf dem 3. Parameter werden alle Punkte (fuer Max) addiert.
addiere(Liste,Punkte,Max,Plus, Minus,Durchschnitt,Liste2) :-
	loesche_plus_minus(Liste,Liste1), % loescht die Plus/Minus-Bestrafungen
	% Durchschnitt OHNE plus/minus-Strafen
	% tbd : Sollten hier ALLE kuenstlichen Gebote raus ???
	%       Dann wuerde man fuer die Durchschnittsstrafen nur die echten
	%       Resultate nehmen
	add1(Liste1,P1,Max1),prozente(P1,left,Max1,Durchschnitt),
	calc_plus_minus(Durchschnitt,Plus,Minus),
	% ersetzt Plus/Minus durch korrekte Prozente
	% Liste2 ist jetzt 4stellig !!!
	ersetze_plus_minus(Liste,Plus,Minus,Durchschnitt,Liste2), 
	add2(Liste2,Punkte,Max).

% rundet auf X Stellen nach dem Komma
runde_zahl(Punkte1,Punkte,1) :- Punkte is round(10*Punkte1)/10,!.
runde_zahl(Punkte1,Punkte,2) :- Punkte is round(100*Punkte1)/100.

calc_plus_minus(Proz,60,Proz) :- Proz < 40,!.
calc_plus_minus(Proz,60,40) :- Proz < 60,!.
calc_plus_minus(Proz,Proz,40).
	
% loescht die Plus/Minus/Schnitt-Bestrafungen
loesche_plus_minus([],[]) :- !.
loesche_plus_minus([[_Board,Points,_MaxPoints,Pos]|T],Liste) :- 
	once((Points=p(minus) 
		; 
		Points=p(plus) 
		; 
		Points=p(schnitt) 
		; 
		Points=p(plus,_),Pos=left 
		; 
		Points=p(minus,_),Pos=left 
		; 
		Points=p(schnitt,_),Pos=left 
		; 
		Points=p(_,plus),Pos=right
		; 
		Points=p(_,minus),Pos=right
		; 
		Points=p(_,schnitt),Pos=right
		)),!,
	loesche_plus_minus(T,Liste).
loesche_plus_minus([F|T],[F|Liste]) :-  loesche_plus_minus(T,Liste).

% ersetzt die Plus/Minus-Bestrafungen
ersetze_plus_minus([],_Plus,_Minus,_Schnitt,[]) :- !.
ersetze_plus_minus([[Board,Points,MaxPoints,Pos]|T],Plus,Minus,Schnitt,
	           [[Board,Points,Points1,MaxPoints,Pos]|Liste]) :- 
	once((Points=p(minus),Points1=p(minus(Minus))
		; 
		Points=p(plus) ,Points1=p(plus(Plus))
		; 
		Points=p(schnitt) ,Points1=p(schnitt(Schnitt))
		; 
		Points=p(plus,B),Pos=left ,Points1=p(plus(Plus),B)
		; 
		Points=p(minus,B),Pos=left ,Points1=p(minus(Minus),B)
		; 
		Points=p(schnitt,B),Pos=left ,Points1=p(schnitt(Schnitt),B)
		; 
		Points=p(B,plus),Pos=right,Points1=p(B,plus(Plus))
		; 
		Points=p(B,minus),Pos=right,Points1=p(B,minus(Minus))
		; 
		Points=p(B,schnitt),Pos=right,Points1=p(B,schnitt(Schnitt))
		)),!,
	ersetze_plus_minus(T,Plus,Minus,Schnitt,Liste).
ersetze_plus_minus([[Board,Points,MaxPoints,Pos]|T],Plus,Minus,Schnitt,
	           [[Board,Points,Points,MaxPoints,Pos]|Liste]) :- 
	 ersetze_plus_minus(T,Plus,Minus,Schnitt,Liste).

% 3stellig, Bestrafungen noch unaufgeloest
add1([],0,0) :- !.
add1([[_Board,Points,MaxPoints,Pos]|T],Summe,Max) :- 
	once((Points=p(Pro) ; Points=p(Pro,_),Pos=left ; Points=p(_,Pro),Pos=right)),!,
	(Pro=minus(Pro1);Pro=plus(Pro1);Pro=schnitt(Pro1);Pro=Pro1),!,
	add1(T,Summe1,Max1),
	Summand is MaxPoints*Pro1/100,Summe is Summe1+Summand,
	Max is Max1+MaxPoints.
add1([[_Board,Points,MaxPoints,_Pos]|T],S,Max) :- add1(T,S1,Max1),
	Max is Max1+MaxPoints,S is Points + S1.

% 4stellig, Bestrafungen schon aufgloest
add2([],0,0) :- !.
add2([[_Board,_,Points,MaxPoints,Pos]|T],Summe,Max) :- 
	once((Points=p(Pro) ; Points=p(Pro,_),Pos=left ; Points=p(_,Pro),Pos=right)),!,
	(Pro=minus(Pro1);Pro=plus(Pro1);Pro=schnitt(Pro1);Pro=Pro1),!,
	add2(T,Summe1,Max1),
	Summand is MaxPoints*Pro1/100,Summe is Summe1+Summand,
	Max is Max1+MaxPoints.
add2([[_Board,_,Points,MaxPoints,_Pos]|T],S,Max) :- add2(T,S1,Max1),
	Max is Max1+MaxPoints,S is Points + S1.


% -------------- DUMMY - Praedikate ----------------------
not_dummy(X,Y) :- clause(personen(Liste),true),
	el_gen([X,Y],Liste),
	Y \== dummy,!.

real_runde(Tisch,Runde,NS,OW,Boards) :-
	runde(Tisch,Runde,NS,OW,Boards),
        % write(runde(Tisch,Runde,NS,OW,Boards)),nl,
	(form(paar),not_dummy(NS,_),not_dummy(OW,_)
	;
	 form(individual)).

% ------------ BOARD - KARTEN ----------------------------
/* LAUF-KARTEN */
laufkarten :-
	clause(persons(N),true),leere(bp),
	gener_list(1,N,Liste),menu_window('Laufkarte fuer wen ??',Liste,Spieler),
	clause(runden(Runden),true),
	generiere_zeile([['Laufkarte fuer Spieler ',25],[Spieler,30]],Aus),
	info(prot,Aus,0),
	info(prot,nl,0),
	el_gen(Runde,Runden),tischprorunde(Spieler,Runde),
	fail.
laufkarten.
tischprorunde(Spieler,Runde) :-
	real_runde(Tisch,Runde,NS,OW,Boards),
	(Spieler=NS,Pos='NS',Gegner=OW,Mit=''  	 ;
	 Spieler=OW,Pos='OW',Gegner=NS,Mit=''    ;
	 NS=[Spieler,Partner],Pos='N',Gegner=OW,combine([' mit ',Partner,' '],Mit)    ;
	 NS=[Partner,Spieler],Pos='S',Gegner=OW,combine([' mit ',Partner,' '],Mit)    ;
	 OW=[Spieler,Partner],Pos='O',Gegner=NS,combine([' mit ',Partner,' '],Mit)    ;
	 OW=[Partner,Spieler],Pos='W',Gegner=NS,combine([' mit ',Partner,' '],Mit)),
	 (Gegner=[G1,G2],combine([G1,'+',G2],Gegner1) ; Gegner\=[_,_],Gegner1=Gegner),
	transponiere(Boards,Boardss),
	generiere_zeile(['Spieler/Paar ',Spieler,' spielt in Runde ',Runde,
	  ' am Tisch ',Tisch,' auf ',Pos,Mit,' gegen ',Gegner1,' die Boards '|Boardss],Aus1),
	info(prot,Aus1,40),
	info(prot,nl,0),!.
tischprorunde(Spieler,Runde) :-
	generiere_zeile(['Spieler/Paar ',Spieler,' setzt in Runde ',Runde,' aus.'],Aus1),
	info(prot,Aus1,30),
	info(prot,nl,0).
% setzt fuer Ausgabe Kommata zwischen die Boards 
transponiere([X],[X]):- !.
transponiere([F|T],[F,','|TT]) :- transponiere(T,TT).

% ------------------------  Hilfs-Praedikate ---------------
last1([X],X).              last1([_|L],X) :- last1(L,X).
el(X,[X|_]).               el(X,[X1|Y]) :- X\==X1,el(X,Y).
el_gen(X,[X|_]).           el_gen(X,[_|Y]) :- el_gen(X,Y).
appendd([],X,X) :- !.      appendd([F|T],L1,[F|L2]) :- appendd(T,L1,L2). 
del(X,[X|Y],Y) :- !.       del(X,[X1|Y],[X1|Y1]) :- del(X,Y,Y1).
replace([X|Y],X,X1,[X1|Y]) :- !.
replace([X2|Y],X,X1,[X2|Y1]) :- replace(Y,X,X1,Y1).

enum(L1,L2) :- enum(L1,L2,1).
enum([],[],_) :- !.
enum([[_,X]|Rest],[[N,X]|Rest1],N) :- N1 is N + 1,enum(Rest,Rest1,N1).

gener_list(Bis,Bis,[Bis]) :- !.
gener_list(Von,Bis,[Von|Res]) :- Von<Bis,Von1 is Von+1,gener_list(Von1,Bis,Res).

% ----------- assert ueber die Datei temp.pl -----------
klausel_insert(Klausel) :-
	tell('temp.pl'),
	write(Klausel),write('.'),nl,
	told,
	consult('temp.pl').
